<?php

$tpl = erLhcoreClassTemplate::getInstance('lhchat/single.tpl.php');

if (is_numeric($Params['user_parameters']['chat_id']))
{
    try {
        $chat = erLhcoreClassChat::getSession()->load( 'erLhcoreClassModelChat', $Params['user_parameters']['chat_id']);

        if ( erLhcoreClassChat::hasAccessToRead($chat) )
        {
            $tpl->set('chat_to_load',$chat);
        } else {
            $tpl->setFile('lhchat/errors/adminchatnopermission.tpl.php');
        }
    } catch (Exception $e) {
        $tpl->setFile('lhchat/errors/adminchatnopermission.tpl.php');
    }
}
$tpl->set('chat_id',$Params['user_parameters']['chat_id']);

$Result['content'] = $tpl->fetch();
$Result['pagelayout'] = 'chattabs';
$Result['body_class'] = 'h-100 dashboard-height';

$title = isset($chat) ? $chat->nick : '.';

$Result['path'] = array(array('title' => erTranslationClassLhTranslation::getInstance()->getTranslation('chat/single','Chat started with').' - '.$title))


?>