<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Vpc\V20170312\Models;
use TencentCloud\Common\AbstractModel;

/**
 * @method string getZone() 获取子网所在的可用区ID，不指定将随机选择可用区
 * @method void setZone(string $Zone) 设置子网所在的可用区ID，不指定将随机选择可用区
 * @method boolean getForce() 获取是否强制返回默认VPC
 * @method void setForce(boolean $Force) 设置是否强制返回默认VPC
 */

/**
 *CreateDefaultVpc请求参数结构体
 */
class CreateDefaultVpcRequest extends AbstractModel
{
    /**
     * @var string 子网所在的可用区ID，不指定将随机选择可用区
     */
    public $Zone;

    /**
     * @var boolean 是否强制返回默认VPC
     */
    public $Force;
    /**
     * @param string $Zone 子网所在的可用区ID，不指定将随机选择可用区
     * @param boolean $Force 是否强制返回默认VPC
     */
    function __construct()
    {

    }
    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("Zone",$param) and $param["Zone"] !== null) {
            $this->Zone = $param["Zone"];
        }

        if (array_key_exists("Force",$param) and $param["Force"] !== null) {
            $this->Force = $param["Force"];
        }
    }
}
