<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Sms\V20190711\Models;
use TencentCloud\Common\AbstractModel;

/**
 * @method ModifyTemplateStatus getModifyTemplateStatus() 获取修改模板参数响应
 * @method void setModifyTemplateStatus(ModifyTemplateStatus $ModifyTemplateStatus) 设置修改模板参数响应
 * @method string getRequestId() 获取唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
 * @method void setRequestId(string $RequestId) 设置唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
 */

/**
 *ModifySmsTemplate返回参数结构体
 */
class ModifySmsTemplateResponse extends AbstractModel
{
    /**
     * @var ModifyTemplateStatus 修改模板参数响应
     */
    public $ModifyTemplateStatus;

    /**
     * @var string 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     */
    public $RequestId;
    /**
     * @param ModifyTemplateStatus $ModifyTemplateStatus 修改模板参数响应
     * @param string $RequestId 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     */
    function __construct()
    {

    }
    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("ModifyTemplateStatus",$param) and $param["ModifyTemplateStatus"] !== null) {
            $this->ModifyTemplateStatus = new ModifyTemplateStatus();
            $this->ModifyTemplateStatus->deserialize($param["ModifyTemplateStatus"]);
        }

        if (array_key_exists("RequestId",$param) and $param["RequestId"] !== null) {
            $this->RequestId = $param["RequestId"];
        }
    }
}
