<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Postgres\V20170312\Models;
use TencentCloud\Common\AbstractModel;

/**
 * @method string getRegion() 获取实例所属地域，如: ap-guangzhou，对应RegionSet的Region字段
 * @method void setRegion(string $Region) 设置实例所属地域，如: ap-guangzhou，对应RegionSet的Region字段
 * @method string getZone() 获取实例所属可用区， 如：ap-guangzhou-3，对应ZoneSet的Zone字段
 * @method void setZone(string $Zone) 设置实例所属可用区， 如：ap-guangzhou-3，对应ZoneSet的Zone字段
 * @method integer getProjectId() 获取项目ID
 * @method void setProjectId(integer $ProjectId) 设置项目ID
 * @method string getVpcId() 获取私有网络ID
 * @method void setVpcId(string $VpcId) 设置私有网络ID
 * @method string getSubnetId() 获取SubnetId
 * @method void setSubnetId(string $SubnetId) 设置SubnetId
 * @method string getDBInstanceId() 获取实例ID
 * @method void setDBInstanceId(string $DBInstanceId) 设置实例ID
 * @method string getDBInstanceName() 获取实例名称
 * @method void setDBInstanceName(string $DBInstanceName) 设置实例名称
 * @method string getDBInstanceStatus() 获取实例状态
 * @method void setDBInstanceStatus(string $DBInstanceStatus) 设置实例状态
 * @method integer getDBInstanceMemory() 获取实例分配的内存大小，单位：GB
 * @method void setDBInstanceMemory(integer $DBInstanceMemory) 设置实例分配的内存大小，单位：GB
 * @method integer getDBInstanceStorage() 获取实例分配的存储空间大小，单位：GB
 * @method void setDBInstanceStorage(integer $DBInstanceStorage) 设置实例分配的存储空间大小，单位：GB
 * @method integer getDBInstanceCpu() 获取实例分配的CPU数量，单位：个
 * @method void setDBInstanceCpu(integer $DBInstanceCpu) 设置实例分配的CPU数量，单位：个
 * @method string getDBInstanceClass() 获取售卖规格ID
 * @method void setDBInstanceClass(string $DBInstanceClass) 设置售卖规格ID
 * @method string getDBInstanceType() 获取实例类型，类型有：1、primary（主实例）；2、readonly（只读实例）；3、guard（灾备实例）；4、temp（临时实例）
 * @method void setDBInstanceType(string $DBInstanceType) 设置实例类型，类型有：1、primary（主实例）；2、readonly（只读实例）；3、guard（灾备实例）；4、temp（临时实例）
 * @method string getDBInstanceVersion() 获取实例版本，目前只支持standard（双机高可用版, 一主一从）
 * @method void setDBInstanceVersion(string $DBInstanceVersion) 设置实例版本，目前只支持standard（双机高可用版, 一主一从）
 * @method string getDBCharset() 获取实例DB字符集
 * @method void setDBCharset(string $DBCharset) 设置实例DB字符集
 * @method string getDBVersion() 获取PostgreSQL内核版本
 * @method void setDBVersion(string $DBVersion) 设置PostgreSQL内核版本
 * @method string getCreateTime() 获取实例创建时间
 * @method void setCreateTime(string $CreateTime) 设置实例创建时间
 * @method string getUpdateTime() 获取实例执行最后一次更新的时间
 * @method void setUpdateTime(string $UpdateTime) 设置实例执行最后一次更新的时间
 * @method string getExpireTime() 获取实例到期时间
 * @method void setExpireTime(string $ExpireTime) 设置实例到期时间
 * @method string getIsolatedTime() 获取实例隔离时间
 * @method void setIsolatedTime(string $IsolatedTime) 设置实例隔离时间
 * @method string getPayType() 获取计费模式，1、prepaid（包年包月,预付费）；2、postpaid（按量计费，后付费）
 * @method void setPayType(string $PayType) 设置计费模式，1、prepaid（包年包月,预付费）；2、postpaid（按量计费，后付费）
 * @method integer getAutoRenew() 获取是否自动续费，1：自动续费，0：不自动续费
 * @method void setAutoRenew(integer $AutoRenew) 设置是否自动续费，1：自动续费，0：不自动续费
 * @method array getDBInstanceNetInfo() 获取实例网络连接信息
 * @method void setDBInstanceNetInfo(array $DBInstanceNetInfo) 设置实例网络连接信息
 * @method string getType() 获取机器类型
 * @method void setType(string $Type) 设置机器类型
 */

/**
 *描述实例的详细信息
 */
class DBInstance extends AbstractModel
{
    /**
     * @var string 实例所属地域，如: ap-guangzhou，对应RegionSet的Region字段
     */
    public $Region;

    /**
     * @var string 实例所属可用区， 如：ap-guangzhou-3，对应ZoneSet的Zone字段
     */
    public $Zone;

    /**
     * @var integer 项目ID
     */
    public $ProjectId;

    /**
     * @var string 私有网络ID
     */
    public $VpcId;

    /**
     * @var string SubnetId
     */
    public $SubnetId;

    /**
     * @var string 实例ID
     */
    public $DBInstanceId;

    /**
     * @var string 实例名称
     */
    public $DBInstanceName;

    /**
     * @var string 实例状态
     */
    public $DBInstanceStatus;

    /**
     * @var integer 实例分配的内存大小，单位：GB
     */
    public $DBInstanceMemory;

    /**
     * @var integer 实例分配的存储空间大小，单位：GB
     */
    public $DBInstanceStorage;

    /**
     * @var integer 实例分配的CPU数量，单位：个
     */
    public $DBInstanceCpu;

    /**
     * @var string 售卖规格ID
     */
    public $DBInstanceClass;

    /**
     * @var string 实例类型，类型有：1、primary（主实例）；2、readonly（只读实例）；3、guard（灾备实例）；4、temp（临时实例）
     */
    public $DBInstanceType;

    /**
     * @var string 实例版本，目前只支持standard（双机高可用版, 一主一从）
     */
    public $DBInstanceVersion;

    /**
     * @var string 实例DB字符集
     */
    public $DBCharset;

    /**
     * @var string PostgreSQL内核版本
     */
    public $DBVersion;

    /**
     * @var string 实例创建时间
     */
    public $CreateTime;

    /**
     * @var string 实例执行最后一次更新的时间
     */
    public $UpdateTime;

    /**
     * @var string 实例到期时间
     */
    public $ExpireTime;

    /**
     * @var string 实例隔离时间
     */
    public $IsolatedTime;

    /**
     * @var string 计费模式，1、prepaid（包年包月,预付费）；2、postpaid（按量计费，后付费）
     */
    public $PayType;

    /**
     * @var integer 是否自动续费，1：自动续费，0：不自动续费
     */
    public $AutoRenew;

    /**
     * @var array 实例网络连接信息
     */
    public $DBInstanceNetInfo;

    /**
     * @var string 机器类型
     */
    public $Type;
    /**
     * @param string $Region 实例所属地域，如: ap-guangzhou，对应RegionSet的Region字段
     * @param string $Zone 实例所属可用区， 如：ap-guangzhou-3，对应ZoneSet的Zone字段
     * @param integer $ProjectId 项目ID
     * @param string $VpcId 私有网络ID
     * @param string $SubnetId SubnetId
     * @param string $DBInstanceId 实例ID
     * @param string $DBInstanceName 实例名称
     * @param string $DBInstanceStatus 实例状态
     * @param integer $DBInstanceMemory 实例分配的内存大小，单位：GB
     * @param integer $DBInstanceStorage 实例分配的存储空间大小，单位：GB
     * @param integer $DBInstanceCpu 实例分配的CPU数量，单位：个
     * @param string $DBInstanceClass 售卖规格ID
     * @param string $DBInstanceType 实例类型，类型有：1、primary（主实例）；2、readonly（只读实例）；3、guard（灾备实例）；4、temp（临时实例）
     * @param string $DBInstanceVersion 实例版本，目前只支持standard（双机高可用版, 一主一从）
     * @param string $DBCharset 实例DB字符集
     * @param string $DBVersion PostgreSQL内核版本
     * @param string $CreateTime 实例创建时间
     * @param string $UpdateTime 实例执行最后一次更新的时间
     * @param string $ExpireTime 实例到期时间
     * @param string $IsolatedTime 实例隔离时间
     * @param string $PayType 计费模式，1、prepaid（包年包月,预付费）；2、postpaid（按量计费，后付费）
     * @param integer $AutoRenew 是否自动续费，1：自动续费，0：不自动续费
     * @param array $DBInstanceNetInfo 实例网络连接信息
     * @param string $Type 机器类型
     */
    function __construct()
    {

    }
    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("Region",$param) and $param["Region"] !== null) {
            $this->Region = $param["Region"];
        }

        if (array_key_exists("Zone",$param) and $param["Zone"] !== null) {
            $this->Zone = $param["Zone"];
        }

        if (array_key_exists("ProjectId",$param) and $param["ProjectId"] !== null) {
            $this->ProjectId = $param["ProjectId"];
        }

        if (array_key_exists("VpcId",$param) and $param["VpcId"] !== null) {
            $this->VpcId = $param["VpcId"];
        }

        if (array_key_exists("SubnetId",$param) and $param["SubnetId"] !== null) {
            $this->SubnetId = $param["SubnetId"];
        }

        if (array_key_exists("DBInstanceId",$param) and $param["DBInstanceId"] !== null) {
            $this->DBInstanceId = $param["DBInstanceId"];
        }

        if (array_key_exists("DBInstanceName",$param) and $param["DBInstanceName"] !== null) {
            $this->DBInstanceName = $param["DBInstanceName"];
        }

        if (array_key_exists("DBInstanceStatus",$param) and $param["DBInstanceStatus"] !== null) {
            $this->DBInstanceStatus = $param["DBInstanceStatus"];
        }

        if (array_key_exists("DBInstanceMemory",$param) and $param["DBInstanceMemory"] !== null) {
            $this->DBInstanceMemory = $param["DBInstanceMemory"];
        }

        if (array_key_exists("DBInstanceStorage",$param) and $param["DBInstanceStorage"] !== null) {
            $this->DBInstanceStorage = $param["DBInstanceStorage"];
        }

        if (array_key_exists("DBInstanceCpu",$param) and $param["DBInstanceCpu"] !== null) {
            $this->DBInstanceCpu = $param["DBInstanceCpu"];
        }

        if (array_key_exists("DBInstanceClass",$param) and $param["DBInstanceClass"] !== null) {
            $this->DBInstanceClass = $param["DBInstanceClass"];
        }

        if (array_key_exists("DBInstanceType",$param) and $param["DBInstanceType"] !== null) {
            $this->DBInstanceType = $param["DBInstanceType"];
        }

        if (array_key_exists("DBInstanceVersion",$param) and $param["DBInstanceVersion"] !== null) {
            $this->DBInstanceVersion = $param["DBInstanceVersion"];
        }

        if (array_key_exists("DBCharset",$param) and $param["DBCharset"] !== null) {
            $this->DBCharset = $param["DBCharset"];
        }

        if (array_key_exists("DBVersion",$param) and $param["DBVersion"] !== null) {
            $this->DBVersion = $param["DBVersion"];
        }

        if (array_key_exists("CreateTime",$param) and $param["CreateTime"] !== null) {
            $this->CreateTime = $param["CreateTime"];
        }

        if (array_key_exists("UpdateTime",$param) and $param["UpdateTime"] !== null) {
            $this->UpdateTime = $param["UpdateTime"];
        }

        if (array_key_exists("ExpireTime",$param) and $param["ExpireTime"] !== null) {
            $this->ExpireTime = $param["ExpireTime"];
        }

        if (array_key_exists("IsolatedTime",$param) and $param["IsolatedTime"] !== null) {
            $this->IsolatedTime = $param["IsolatedTime"];
        }

        if (array_key_exists("PayType",$param) and $param["PayType"] !== null) {
            $this->PayType = $param["PayType"];
        }

        if (array_key_exists("AutoRenew",$param) and $param["AutoRenew"] !== null) {
            $this->AutoRenew = $param["AutoRenew"];
        }

        if (array_key_exists("DBInstanceNetInfo",$param) and $param["DBInstanceNetInfo"] !== null) {
            $this->DBInstanceNetInfo = [];
            foreach ($param["DBInstanceNetInfo"] as $key => $value){
                $obj = new DBInstanceNetInfo();
                $obj->deserialize($value);
                array_push($this->DBInstanceNetInfo, $obj);
            }
        }

        if (array_key_exists("Type",$param) and $param["Type"] !== null) {
            $this->Type = $param["Type"];
        }
    }
}
