<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Live\V20180801\Models;
use TencentCloud\Common\AbstractModel;

/**
 * @method string getTime() 获取数据时间点。
 * @method void setTime(string $Time) 设置数据时间点。
 * @method float getValue() 获取带宽/流量/请求数/并发连接数/下载速度的值，若没数据返回时该值为0
注意：此字段可能返回 null，表示取不到有效值。
 * @method void setValue(float $Value) 设置带宽/流量/请求数/并发连接数/下载速度的值，若没数据返回时该值为0
注意：此字段可能返回 null，表示取不到有效值。
 */

/**
 *按省份运营商查询的播放信息
 */
class PlayStatInfo extends AbstractModel
{
    /**
     * @var string 数据时间点。
     */
    public $Time;

    /**
     * @var float 带宽/流量/请求数/并发连接数/下载速度的值，若没数据返回时该值为0
注意：此字段可能返回 null，表示取不到有效值。
     */
    public $Value;
    /**
     * @param string $Time 数据时间点。
     * @param float $Value 带宽/流量/请求数/并发连接数/下载速度的值，若没数据返回时该值为0
注意：此字段可能返回 null，表示取不到有效值。
     */
    function __construct()
    {

    }
    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("Time",$param) and $param["Time"] !== null) {
            $this->Time = $param["Time"];
        }

        if (array_key_exists("Value",$param) and $param["Value"] !== null) {
            $this->Value = $param["Value"];
        }
    }
}
