<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Gaap\V20180529\Models;
use TencentCloud\Common\AbstractModel;

/**
 * @method string getErrorPageId() 获取定制错误响应页的唯一ID，请参考CreateDomainErrorPageInfo的响应
 * @method void setErrorPageId(string $ErrorPageId) 设置定制错误响应页的唯一ID，请参考CreateDomainErrorPageInfo的响应
 */

/**
 *DeleteDomainErrorPageInfo请求参数结构体
 */
class DeleteDomainErrorPageInfoRequest extends AbstractModel
{
    /**
     * @var string 定制错误响应页的唯一ID，请参考CreateDomainErrorPageInfo的响应
     */
    public $ErrorPageId;
    /**
     * @param string $ErrorPageId 定制错误响应页的唯一ID，请参考CreateDomainErrorPageInfo的响应
     */
    function __construct()
    {

    }
    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("ErrorPageId",$param) and $param["ErrorPageId"] !== null) {
            $this->ErrorPageId = $param["ErrorPageId"];
        }
    }
}
