<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Cpdp\V20190820\Models;
use TencentCloud\Common\AbstractModel;

/**
 * @method string getMidasAppId() 获取聚鑫分配的支付主MidasAppId
 * @method void setMidasAppId(string $MidasAppId) 设置聚鑫分配的支付主MidasAppId
 * @method string getSubAppId() 获取聚鑫计费SubAppId，代表子商户
 * @method void setSubAppId(string $SubAppId) 设置聚鑫计费SubAppId，代表子商户
 * @method integer getBindType() 获取1 – 小额转账验证
2 – 短信验证
每个结算账户每天只能使用一次小额转账验证
 * @method void setBindType(integer $BindType) 设置1 – 小额转账验证
2 – 短信验证
每个结算账户每天只能使用一次小额转账验证
 * @method string getSettleAcctNo() 获取用于提现
<敏感信息>加密详见《商户端接口敏感信息加密说明》
 * @method void setSettleAcctNo(string $SettleAcctNo) 设置用于提现
<敏感信息>加密详见《商户端接口敏感信息加密说明》
 * @method string getSettleAcctName() 获取结算账户户名
<敏感信息>加密详见《商户端接口敏感信息加密说明》
 * @method void setSettleAcctName(string $SettleAcctName) 设置结算账户户名
<敏感信息>加密详见《商户端接口敏感信息加密说明》
 * @method integer getSettleAcctType() 获取1 – 本行账户
2 – 他行账户
 * @method void setSettleAcctType(integer $SettleAcctType) 设置1 – 本行账户
2 – 他行账户
 * @method string getIdType() 获取证件类型，见《证件类型》表
 * @method void setIdType(string $IdType) 设置证件类型，见《证件类型》表
 * @method string getIdCode() 获取证件号码
<敏感信息>加密详见《商户端接口敏感信息加密说明》
 * @method void setIdCode(string $IdCode) 设置证件号码
<敏感信息>加密详见《商户端接口敏感信息加密说明》
 * @method string getAcctBranchName() 获取开户行名称
 * @method void setAcctBranchName(string $AcctBranchName) 设置开户行名称
 * @method string getMidasSecretId() 获取聚鑫分配的安全ID
 * @method void setMidasSecretId(string $MidasSecretId) 设置聚鑫分配的安全ID
 * @method string getMidasSignature() 获取按照聚鑫安全密钥计算的签名
 * @method void setMidasSignature(string $MidasSignature) 设置按照聚鑫安全密钥计算的签名
 * @method string getMobile() 获取用于短信验证
BindType==2时必填
<敏感信息>加密详见《商户端接口敏感信息加密说明》
 * @method void setMobile(string $Mobile) 设置用于短信验证
BindType==2时必填
<敏感信息>加密详见《商户端接口敏感信息加密说明》
 * @method string getCnapsBranchId() 获取超级网银行号和大小额行号
二选一
 * @method void setCnapsBranchId(string $CnapsBranchId) 设置超级网银行号和大小额行号
二选一
 * @method string getEiconBankBranchId() 获取超级网银行号和大小额行号
二选一
 * @method void setEiconBankBranchId(string $EiconBankBranchId) 设置超级网银行号和大小额行号
二选一
 */

/**
 *BindAcct请求参数结构体
 */
class BindAcctRequest extends AbstractModel
{
    /**
     * @var string 聚鑫分配的支付主MidasAppId
     */
    public $MidasAppId;

    /**
     * @var string 聚鑫计费SubAppId，代表子商户
     */
    public $SubAppId;

    /**
     * @var integer 1 – 小额转账验证
2 – 短信验证
每个结算账户每天只能使用一次小额转账验证
     */
    public $BindType;

    /**
     * @var string 用于提现
<敏感信息>加密详见《商户端接口敏感信息加密说明》
     */
    public $SettleAcctNo;

    /**
     * @var string 结算账户户名
<敏感信息>加密详见《商户端接口敏感信息加密说明》
     */
    public $SettleAcctName;

    /**
     * @var integer 1 – 本行账户
2 – 他行账户
     */
    public $SettleAcctType;

    /**
     * @var string 证件类型，见《证件类型》表
     */
    public $IdType;

    /**
     * @var string 证件号码
<敏感信息>加密详见《商户端接口敏感信息加密说明》
     */
    public $IdCode;

    /**
     * @var string 开户行名称
     */
    public $AcctBranchName;

    /**
     * @var string 聚鑫分配的安全ID
     */
    public $MidasSecretId;

    /**
     * @var string 按照聚鑫安全密钥计算的签名
     */
    public $MidasSignature;

    /**
     * @var string 用于短信验证
BindType==2时必填
<敏感信息>加密详见《商户端接口敏感信息加密说明》
     */
    public $Mobile;

    /**
     * @var string 超级网银行号和大小额行号
二选一
     */
    public $CnapsBranchId;

    /**
     * @var string 超级网银行号和大小额行号
二选一
     */
    public $EiconBankBranchId;
    /**
     * @param string $MidasAppId 聚鑫分配的支付主MidasAppId
     * @param string $SubAppId 聚鑫计费SubAppId，代表子商户
     * @param integer $BindType 1 – 小额转账验证
2 – 短信验证
每个结算账户每天只能使用一次小额转账验证
     * @param string $SettleAcctNo 用于提现
<敏感信息>加密详见《商户端接口敏感信息加密说明》
     * @param string $SettleAcctName 结算账户户名
<敏感信息>加密详见《商户端接口敏感信息加密说明》
     * @param integer $SettleAcctType 1 – 本行账户
2 – 他行账户
     * @param string $IdType 证件类型，见《证件类型》表
     * @param string $IdCode 证件号码
<敏感信息>加密详见《商户端接口敏感信息加密说明》
     * @param string $AcctBranchName 开户行名称
     * @param string $MidasSecretId 聚鑫分配的安全ID
     * @param string $MidasSignature 按照聚鑫安全密钥计算的签名
     * @param string $Mobile 用于短信验证
BindType==2时必填
<敏感信息>加密详见《商户端接口敏感信息加密说明》
     * @param string $CnapsBranchId 超级网银行号和大小额行号
二选一
     * @param string $EiconBankBranchId 超级网银行号和大小额行号
二选一
     */
    function __construct()
    {

    }
    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("MidasAppId",$param) and $param["MidasAppId"] !== null) {
            $this->MidasAppId = $param["MidasAppId"];
        }

        if (array_key_exists("SubAppId",$param) and $param["SubAppId"] !== null) {
            $this->SubAppId = $param["SubAppId"];
        }

        if (array_key_exists("BindType",$param) and $param["BindType"] !== null) {
            $this->BindType = $param["BindType"];
        }

        if (array_key_exists("SettleAcctNo",$param) and $param["SettleAcctNo"] !== null) {
            $this->SettleAcctNo = $param["SettleAcctNo"];
        }

        if (array_key_exists("SettleAcctName",$param) and $param["SettleAcctName"] !== null) {
            $this->SettleAcctName = $param["SettleAcctName"];
        }

        if (array_key_exists("SettleAcctType",$param) and $param["SettleAcctType"] !== null) {
            $this->SettleAcctType = $param["SettleAcctType"];
        }

        if (array_key_exists("IdType",$param) and $param["IdType"] !== null) {
            $this->IdType = $param["IdType"];
        }

        if (array_key_exists("IdCode",$param) and $param["IdCode"] !== null) {
            $this->IdCode = $param["IdCode"];
        }

        if (array_key_exists("AcctBranchName",$param) and $param["AcctBranchName"] !== null) {
            $this->AcctBranchName = $param["AcctBranchName"];
        }

        if (array_key_exists("MidasSecretId",$param) and $param["MidasSecretId"] !== null) {
            $this->MidasSecretId = $param["MidasSecretId"];
        }

        if (array_key_exists("MidasSignature",$param) and $param["MidasSignature"] !== null) {
            $this->MidasSignature = $param["MidasSignature"];
        }

        if (array_key_exists("Mobile",$param) and $param["Mobile"] !== null) {
            $this->Mobile = $param["Mobile"];
        }

        if (array_key_exists("CnapsBranchId",$param) and $param["CnapsBranchId"] !== null) {
            $this->CnapsBranchId = $param["CnapsBranchId"];
        }

        if (array_key_exists("EiconBankBranchId",$param) and $param["EiconBankBranchId"] !== null) {
            $this->EiconBankBranchId = $param["EiconBankBranchId"];
        }
    }
}
